#ifndef INMALYZEWIFI_H
#define INMALYZEWIFI_H

#include <Arduino.h>
#include <WiFi.h>
#include <WebServer.h>
#include <map>

class InmalyzeWIFI {
  public:
    InmalyzeWIFI();
    
    // Connects to WiFi and starts the server
    void begin(const char* ssid, const char* password);
    
    // Must be called in void loop()
    void loop();

    // Send data to the dashboard (Update the API response)
    void send(String key, String value);
    void send(String key, int value);
    void send(String key, float value);

    // Get data received from the dashboard (Read control values)
    String get(String key);

  private:
    WebServer server;
    std::map<String, String> dataStore; // Stores all Key-Value pairs

    void handleRoot();
    void handleControl();
    void handleOptions();
    void setCORSHeaders();
};

#endif