#ifndef INMALYZE_API_H
#define INMALYZE_API_H

#include <ArduinoJson.h>
#include <HTTPClient.h>
#include <WiFi.h>

class InmalyzeAPI {
public:
  InmalyzeAPI(const char *authKey_, const char *deviceKey_);

  bool update();

  template <typename T> void send(const char *key, T value) {
    sendDoc[key] = value;
  }

  template <typename T> T get(const char *key, T defaultValue) {
    if (receiveDoc.containsKey("controls")) {
      JsonObject controls = receiveDoc["controls"];
      if (controls.containsKey(key)) {
        return controls[key].as<T>();
      }
    }
    return defaultValue;
  }

  bool get(const char *key);

private:
  const char *serverUrl;
  const char *authKey;
  const char *deviceKey;

  DynamicJsonDocument sendDoc = DynamicJsonDocument(512);
  DynamicJsonDocument receiveDoc = DynamicJsonDocument(1024);

  void clearPayload();
};

#endif