#include "InmalyzeAPI.h"

// Constructor implementation
InmalyzeAPI::InmalyzeAPI(const char *authKey_, const char *deviceKey_)
    : serverUrl("https://inmalyze.com/api/device/data"), authKey(authKey_),
      deviceKey(deviceKey_) {
  // Initialization logic if needed
}

// Private method implementation
void InmalyzeAPI::clearPayload() { sendDoc.clear(); }

// Public method implementation: Send data and receive controls
bool InmalyzeAPI::update() {
  send("Device_status", 200);

  if (WiFi.status() != WL_CONNECTED) {
    Serial.println("InmalyzeAPI: WiFi Disconnected.");
    clearPayload();
    return false;
  }

  HTTPClient http;
  http.begin(serverUrl);
  http.addHeader("Content-Type", "application/json");
  http.addHeader("x-inmalyze-auth", authKey);
  http.addHeader("x-inmalyze-device", deviceKey);

  String jsonPayload;
  serializeJson(sendDoc, jsonPayload);

  int httpResponseCode = http.POST(jsonPayload);
  bool success = false;

  if (httpResponseCode > 0) {
    String response = http.getString();

    // Clear previous receive data
    receiveDoc.clear();
    DeserializationError error = deserializeJson(receiveDoc, response);

    if (!error) {
      success = true;
    }
  }

  http.end();
  clearPayload();
  if (success) {
  }
  return success;
}

// Public method implementation: Boolean getter overload
bool InmalyzeAPI::get(const char *key) { return get<int>(key, 0) == 1; }